\name{makeCustomResampledMeasure}
\alias{makeCustomResampledMeasure}
\title{Construct your own resampled performance measure.}
\usage{
  makeCustomResampledMeasure(id, minimize = TRUE,
    classif = FALSE, regr = FALSE, only.binary = FALSE,
    allowed.pred.types = character(0L), fun,
    extra.args = list())
}
\arguments{
  \item{id}{[\code{character(1)}]\cr Name of aggregated
  measure.}

  \item{minimize}{[\code{logical(1)}]\cr Should the measure
  be minimized?  Default is \code{TRUE}.}

  \item{classif}{[\code{logical(1)}]\cr Is the measure
  applicable for classification?  Default is \code{FALSE}.}

  \item{regr}{[\code{logical(1)}]\cr Is the measure
  applicable for regression?  Default is \code{FALSE}.}

  \item{only.binary}{[\code{logical(1)}]\cr Is the measure
  only applicable to binary classification?  Only
  reasonable if \code{classif} is \code{TRUE}.  Default is
  \code{FALSE}.}

  \item{allowed.pred.types}{[\code{character}] Which
  prediction types are allowed for this measure?  Subset of
  \dQuote{response},\dQuote{prob},\dQuote{se}.  Default is
  none.}

  \item{fun}{[\code{function(task, pred, group, pred,
  extra.args)}]\cr Calculates performance value from
  \code{\link{ResamplePrediction}} object.  For rare case
  you can also use the task, the grouping or the extra
  arguments \code{extra.args}.}

  \item{extra.args}{[\code{list}]\cr List of extra
  arguments which will always be passed to \code{fun}.
  Default is empty list.}
}
\value{
  \code{\link{Measure}}
}
\description{
  Construct your own performance measure, used after
  resampling. Note that individual training / test set
  performance values will be set to \code{NA}, you only
  calculate an aggregated value. If you can define a
  function that makes sense for every single training /
  test set, implement your own \code{\link{Measure}}.
}

