% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Learner_properties.R
\name{LearnerProperties}
\alias{LearnerProperties}
\alias{getLearnerProperties}
\alias{hasLearnerProperties}
\alias{getLearnerProperties}
\alias{hasLearnerProperties}
\title{Query properties of learners.}
\usage{
getLearnerProperties(learner)

hasLearnerProperties(learner, props)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{props}{[\code{character}]\cr
Vector of properties to query.}
}
\value{
\code{getLearnerProperties} returns a character vector with learner properties.
 \code{hasLearnerProperties} returns a logical vector of the same length as \code{props}.
}
\description{
Properties can be accessed with \code{getLearnerProperties(learner)}, which returns a
character vector.

The learner properties are defined as follows:
\describe{
  \item{numerics, factors, ordered}{Can numeric, factor or ordered factor features be handled?}
  \item{missings}{Can missing values in features be handled?}
  \item{weights}{Can observations be weighted during fitting?}
  \item{oneclas, twoclass, multiclass}{Only for classif: Can one-class, two-class or multi-class classification problems be handled?}
  \item{class.weights}{Only for classif: Can class weights be handled?}
  \item{rcens, lcens, icens}{Only for surv: Can right, left, or interval censored data be handled?}
  \item{prob}{For classif, cluster, multilabel, surv: Can probabilites be predicted?}
  \item{se}{Only for regr: Can standard errors be predicted?}
  \item{featimp}{For classif, regr, surv: Does the model support extracting information on feature importance?}
}
}
\seealso{
Other learner: \code{\link{getClassWeightParam}},
  \code{\link{getHyperPars}}, \code{\link{getLearnerId}},
  \code{\link{getLearnerPackages}},
  \code{\link{getLearnerParVals}},
  \code{\link{getLearnerParamSet}},
  \code{\link{getLearnerPredictType}},
  \code{\link{getLearnerShortName}},
  \code{\link{getLearnerType}}, \code{\link{getParamSet}},
  \code{\link{makeLearners}}, \code{\link{makeLearner}},
  \code{\link{removeHyperPars}},
  \code{\link{setHyperPars}}, \code{\link{setId}},
  \code{\link{setLearnerId}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
