% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure_make_cost.R
\name{makeCostMeasure}
\alias{makeCostMeasure}
\title{Creates a measure for non-standard misclassification costs.}
\usage{
makeCostMeasure(id = "costs", minimize = TRUE, costs, combine = mean,
  best = NULL, worst = NULL, name = id, note = "")
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Name of measure.
Default is \dQuote{costs}.}

\item{minimize}{[\code{logical(1)}]\cr
Should the measure be minimized?
Otherwise you are effectively specifying a benefits matrix.
Default is \code{TRUE}.}

\item{costs}{[\code{matrix}]\cr
Matrix of misclassification costs. Rows and columns have to be named with class labels, order does not matter.
Rows indicate true classes, columns predicted classes.}

\item{combine}{[\code{function}]\cr
How to combine costs over all cases for a SINGLE test set?
Note this is not the same as the \code{aggregate} argument in \code{\link{makeMeasure}}
You can set this as well via \code{\link{setAggregation}}, as for any measure.
Default is \code{\link{mean}}.}

\item{best}{[\code{numeric(1)}]\cr
Best obtainable value for measure.
Default is -\code{Inf} or \code{Inf}, depending on \code{minimize}.}

\item{worst}{[\code{numeric(1)}]\cr
Worst obtainable value for measure.
Default is \code{Inf} or -\code{Inf}, depending on \code{minimize}.}

\item{name}{[\code{character}] \cr
Name of the measure. Default is \code{id}.}

\item{note}{[\code{character}] \cr
Description and additional notes for the measure. Default is \dQuote{}.}
}
\value{
[\code{\link{Measure}}].
}
\description{
Creates a cost measure for non-standard classification error costs.
}
\seealso{
Other performance: \code{\link{ConfusionMatrix}},
  \code{\link{calculateConfusionMatrix}},
  \code{\link{calculateROCMeasures}},
  \code{\link{estimateRelativeOverfitting}},
  \code{\link{makeCustomResampledMeasure}},
  \code{\link{makeMeasure}}, \code{\link{measures}},
  \code{\link{performance}}
}
