% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictLearner.R
\name{predictLearner}
\alias{predictLearner}
\title{Predict new data with an R learner.}
\usage{
predictLearner(.learner, .model, .newdata, ...)
}
\arguments{
\item{.learner}{[\code{\link{RLearner}}]\cr
Wrapped learner.}

\item{.model}{[\code{\link{WrappedModel}}]\cr
Model produced by training.}

\item{.newdata}{[\code{data.frame}]\cr
New data to predict. Does not include target column.}

\item{...}{[any]\cr
Additional parameters, which need to be passed to the underlying predict function.}
}
\value{
\itemize{
  \item For classification: Either a factor with class labels for type
    \dQuote{response} or, if the learner supports this, a matrix of class probabilities
    for type \dQuote{prob}. In the latter case the columns must be named with the class
    labels.
  \item For regression: Either a numeric vector for type \dQuote{response} or,
    if the learner supports this, a matrix with two columns for type \dQuote{se}.
    In the latter case the first column contains the estimated response (mean value)
    and the second column the estimated standard errors.
  \item For survival: Either a numeric vector with some sort of orderable risk
    for type \dQuote{response} or, if supported, a numeric vector with time dependent
    probabilities for type \dQuote{prob}.
  \item For clustering: Either an integer with cluster IDs for type \dQuote{response}
    or, if supported, a matrix of membership probabilities for type \dQuote{prob}.
  \item For multilabel: A logical matrix that indicates predicted class labels for type
    \dQuote{response} or, if supported, a matrix of class probabilities for type
    \dQuote{prob}. The columns must be named with the class labels.
 }
}
\description{
Mainly for internal use. Predict new data with a fitted model.
You have to implement this method if you want to add another learner to this package.
}
\details{
Your implementation must adhere to the following:
Predictions for the observations in \code{.newdata} must be made based on the fitted
model (\code{.model$learner.model}).
All parameters in \code{...} must be passed to the underlying predict function.
}
