% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingHoldout.R
\docType{data}
\name{ResamplingHoldout}
\alias{ResamplingHoldout}
\alias{mlr_resamplings_holdout}
\title{Holdout Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\usage{
ResamplingHoldout
}
\description{
Splits data into a single training set and a test set.
Parameter \code{ratio} determines the ratio of observation in the train set (default: 2/3).
}
\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\examples{
# Create a task with 10 observations
task = mlr_tasks$get("iris")
task$filter(1:10)

# Instantiate Resampling
rho = mlr_resamplings$get("holdout")
rho$instantiate(task)

# Individual sets:
rho$train_set(1)
rho$test_set(1)
intersect(rho$train_set(1), rho$test_set(1))

# Internal storage:
rho$instance # simple list
}
\keyword{datasets}
