% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3-package}
\alias{mlr3}
\alias{mlr3-package}
\title{mlr3: Machine Learning in R - Next Generation}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Efficient, object-oriented programming on the
    building blocks of machine learning. Provides 'R6' objects for tasks,
    learners, resamplings, and measures. The package is geared towards
    scalability and larger datasets by supporting parallelization and
    out-of-memory data-backends like databases. While 'mlr3' focuses on
    the core computational operations, add-on packages provide additional
    functionality.
}
\section{Additional resources}{

\itemize{
\item Book on mlr3: \url{https://mlr3book.mlr-org.com}
\item Use cases and examples: \url{https://mlr3gallery.mlr-org.com}
\item More classification and regression learners: \CRANpkg{mlr3learners}
\item Preprocessing and machine learning pipelines: \CRANpkg{mlr3pipelines}
\item Tuning of hyperparameters: \CRANpkg{mlr3tuning}
\item Visualizations for many \pkg{mlr3} objects: \CRANpkg{mlr3viz}
\item Survival analysis and probabilistic regression: \CRANpkg{mlr3proba}
\item Feature selection filters: \CRANpkg{mlr3filters}
\item Interface to real (out-of-memory) data bases: \CRANpkg{mlr3db}
\item Performance measures as plain functions: \CRANpkg{mlr3measures}
\item Parallelization framework: \CRANpkg{future}
\item Progress bars: \CRANpkg{progressr}
}
}

\references{
\cite{mlr3}{pkg::citation}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3/issues}
}

}
\author{
\strong{Maintainer}: Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID})

Authors:
\itemize{
  \item Bernd Bischl \email{bernd_bischl@gmx.net} (\href{https://orcid.org/0000-0001-6002-6980}{ORCID})
  \item Jakob Richter \email{jakob1richter@gmail.com} (\href{https://orcid.org/0000-0003-4481-5554}{ORCID})
  \item Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})
  \item Martin Binder \email{mlr.developer@mb706.com}
}

Other contributors:
\itemize{
  \item Giuseppe Casalicchio \email{giuseppe.casalicchio@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0001-5324-5966}{ORCID}) [contributor]
  \item Stefan Coors \email{mail@stefancoors.de} (\href{https://orcid.org/0000-0002-7465-2146}{ORCID}) [contributor]
  \item Quay Au \email{quayau@gmail.com} (\href{https://orcid.org/0000-0002-5252-8902}{ORCID}) [contributor]
}

}
