% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_threads.R
\name{set_threads}
\alias{set_threads}
\alias{set_threads.default}
\alias{set_threads.R6}
\alias{set_threads.list}
\title{Set the Number of Threads}
\usage{
set_threads(x, n = availableCores())

\method{set_threads}{default}(x, n = availableCores())

\method{set_threads}{R6}(x, n = availableCores())

\method{set_threads}{list}(x, n = availableCores())
}
\arguments{
\item{x}{(any)\cr
Object to set threads for, e.g. a \link{Learner}.
This object is modified in-place.}

\item{n}{(\code{integer(1)})\cr
Number of threads to use. Defaults to \code{\link[parallelly:availableCores]{parallelly::availableCores()}}.}
}
\value{
Same object as input \code{x} (changed in-place),
with possibly updated parameter values.
}
\description{
Control the parallelism via threading while calling external packages from \CRANpkg{mlr3}.

For example, the random forest implementation in package \CRANpkg{ranger} (connected
via \CRANpkg{mlr3learners}) supports threading via OpenMP.
The number of threads to use can be set via hyperparameter \code{num.threads}, and
defaults to 1. By calling \code{set_threads(x, 4)} with \code{x} being a ranger learner, the
hyperparameter is changed so that 4 cores are used.

If the object \code{x} does not support threading, \code{x} is returned as-is.
If applied to a list, recurses through all list elements.

Note that threading is incompatible with other parallelization techniques such as forking
via the \link[future:plan]{future::plan} \link[future:multicore]{future::multicore}. For this reason all learners connected to \CRANpkg{mlr3}
have threading disabled in their defaults.
}
