% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrRpart.R
\name{mlr_learners_regr.rpart}
\alias{mlr_learners_regr.rpart}
\alias{LearnerRegrRpart}
\title{Regression Tree Learner}
\description{
Parameter \code{xval} is set to 0 in order to save some computation time.
Parameter \code{model} has been renamed to \code{keep_model}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.rpart")
lrn("regr.rpart")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{rpart}
}
}

\section{Parameters}{

, |Id             |Type    |Default |Levels      |Range                       |, |:--------------|:-------|:-------|:-----------|:---------------------------|, |cp             |numeric |0.01    |            |\eqn{[0, 1]}{[0, 1]}        |, |keep_model     |logical |FALSE   |TRUE, FALSE |-                           |, |maxcompete     |integer |4       |            |\eqn{[0, \infty)}{[0, Inf)} |, |maxdepth       |integer |30      |            |\eqn{[1, 30]}{[1, 30]}      |, |maxsurrogate   |integer |5       |            |\eqn{[0, \infty)}{[0, Inf)} |, |minbucket      |integer |-       |            |\eqn{[1, \infty)}{[1, Inf)} |, |minsplit       |integer |20      |            |\eqn{[1, \infty)}{[1, Inf)} |, |surrogatestyle |integer |0       |            |\eqn{[0, 1]}{[0, 1]}        |, |usesurrogate   |integer |2       |            |\eqn{[0, 2]}{[0, 2]}        |, |xval           |integer |10      |            |\eqn{[0, \infty)}{[0, Inf)} |
}

\references{
Breiman L, Friedman JH, Olshen RA, Stone CJ (1984).
\emph{Classification And Regression Trees}.
Routledge.
\doi{10.1201/9781315139470}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/02-basics-learners.html}
\item Package \CRANpkg{mlr3learners} for a solid collection of essential learners.
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{LearnerClassif}},
\code{\link{LearnerRegr}},
\code{\link{Learner}},
\code{\link{mlr_learners_classif.debug}},
\code{\link{mlr_learners_classif.featureless}},
\code{\link{mlr_learners_classif.rpart}},
\code{\link{mlr_learners_regr.debug}},
\code{\link{mlr_learners_regr.featureless}},
\code{\link{mlr_learners}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrRpart}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrRpart-new}{\code{LearnerRegrRpart$new()}}
\item \href{#method-LearnerRegrRpart-importance}{\code{LearnerRegrRpart$importance()}}
\item \href{#method-LearnerRegrRpart-selected_features}{\code{LearnerRegrRpart$selected_features()}}
\item \href{#method-LearnerRegrRpart-clone}{\code{LearnerRegrRpart$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRpart-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRpart-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRpart$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRpart-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRpart-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRpart$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRpart-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRpart-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
Selected features are extracted from the model slot \code{frame$var}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRpart$selected_features()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRpart-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRpart-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRpart$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
