% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_measures.R
\name{default_measures}
\alias{default_measures}
\title{Get the Default Measure}
\usage{
default_measures(task_type)
}
\arguments{
\item{task_type}{(\code{character(1)})\cr
Get the default measure for the task type \code{task_type}, e.g., \code{"classif"} or \code{"regr"}.
If \code{task_type} is \code{NULL}, an empty list is returned.}
}
\value{
list of \link{Measure}.
}
\description{
Gets the default measures using the information in \link[=mlr_reflections]{mlr_reflections$default_measures}:
\itemize{
\item \code{\link[=mlr_measures_classif.ce]{"classif.ce"}} for classification (\code{"classif"}).
\item \code{\link[=mlr_measures_regr.mse]{"regr.mse"}} for regression (\code{"regr"}).
\item Add-on package may register additional default measures for their own task types.
}
}
\examples{
default_measures("classif")
default_measures("regr")
}
