% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3.model_extractor}
\alias{mlr3.model_extractor}
\title{Model Extractor Callback}
\arguments{
\item{fun}{(\verb{function(learner)})\cr
Function to extract information from the learner.
The function must have the argument \code{learner}.
The function must return a named list.}
}
\description{
This \link{CallbackResample} extracts information from the model after training with a user-defined function.
This way information can be extracted from the model without saving the model (\code{store_models = FALSE}).
The \code{fun} must be a function that takes a learner as input and returns the extracted information as named list (see example).
The callback is very helpful to call \verb{$selected_features()}, \verb{$importance()}, \verb{$oob_error()} on the learner.
}
\examples{
task = tsk("pima")
learner = lrn("classif.rpart")
resampling = rsmp("cv", folds = 3)

# define function to extract selected features
selected_features = function(learner) list(selected_features = learner$selected_features())

# create callback
callback = clbk("mlr3.model_extractor", fun = selected_features)

rr = resample(task, learner, resampling = resampling, store_models = FALSE, callbacks = callback)

rr$data_extra
}
