% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_learners.R
\docType{data}
\name{mlr_learners}
\alias{mlr_learners}
\title{Dictionary of Learners}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{Learner}.
Each learner has an associated help page, see \code{mlr_learners_[id]}.

This dictionary can get populated with additional learners by add-on packages.
For an opinionated set of solid classification and regression learners, install and load the \CRANpkg{mlr3learners} package.
More learners are connected via \url{https://github.com/mlr-org/mlr3extralearners}.

For a more convenient way to retrieve and construct learners, see \code{\link[=lrn]{lrn()}}/\code{\link[=lrns]{lrns()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict, ..., objects = FALSE)}\cr
\link[mlr3misc:Dictionary]{mlr3misc::Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with fields "key", "label", "task_type", "feature_types", "packages",
"properties", and "predict_types" as columns.
If \code{objects} is set to \code{TRUE}, the constructed objects are returned in the list column named \code{object}.
}
}

\examples{
as.data.table(mlr_learners)
mlr_learners$get("classif.featureless")
lrn("classif.rpart")
}
\seealso{
Sugar functions: \code{\link[=lrn]{lrn()}}, \code{\link[=lrns]{lrns()}}

Extension Packages: \CRANpkg{mlr3learners}

Other Dictionary: 
\code{\link{mlr_measures}},
\code{\link{mlr_resamplings}},
\code{\link{mlr_task_generators}},
\code{\link{mlr_tasks}}

Other Learner: 
\code{\link{Learner}},
\code{\link{LearnerClassif}},
\code{\link{LearnerRegr}},
\code{\link{mlr_learners_classif.debug}},
\code{\link{mlr_learners_classif.featureless}},
\code{\link{mlr_learners_classif.rpart}},
\code{\link{mlr_learners_regr.debug}},
\code{\link{mlr_learners_regr.featureless}},
\code{\link{mlr_learners_regr.rpart}}
}
\concept{Dictionary}
\concept{Learner}
\keyword{datasets}
