format_bib = function(...) {
  str = vapply(list(...), function(entry) tools::toRd(bibentries[[entry]]), FUN.VALUE = "")
  paste0(str, collapse = "\n\n")
}

#' @importFrom utils bibentry
bibentries = c( # nolint start
  breiman_2001       = bibentry("article",
    title            = "Random Forests",
    author           = "Breiman, Leo",
    year             = "2001",
    journal          = "Machine Learning",
    volume           = "45",
    number           = "1",
    pages            = "5--32",
    doi              = "10.1023/A:1010933404324",
    issn             = "1573-0565"
  ),
  chen_2016          = bibentry("inproceedings",
    title            = "Xgboost: A scalable tree boosting system",
    author           = "Chen, Tianqi and Guestrin, Carlos",
    year             = "2016",
    booktitle        = "Proceedings of the 22nd ACM SIGKDD Conference on Knowledge Discovery and Data Mining",
    pages            = "785--794",
    doi              = "10.1145/2939672.2939785",
    organization     = "ACM"
  ),
  cortes_1995        = bibentry("article",
    title            = "Support-vector networks",
    author           = "Cortes, Corinna and Vapnik, Vladimir",
    year             = "1995",
    month            = "sep",
    day              = "1",
    journal          = "Machine Learning",
    volume           = "20",
    number           = "3",
    pages            = "273--297",
    doi              = "10.1007/BF00994018"
  ),
  cover_1967         = bibentry("article",
    title            = "Nearest neighbor pattern classification",
    author           = "Cover, Thomas and Hart, Peter",
    year             = "1967",
    journal          = "IEEE transactions on information theory",
    publisher        = "IEEE",
    volume           = "13",
    number           = "1",
    pages            = "21--27",
    doi              = "10.1109/TIT.1967.1053964"
  ),
  friedman_2010      = bibentry("article",
    title            = "Regularization Paths for Generalized Linear Models via Coordinate Descent",
    author           = "Jerome Friedman and Trevor Hastie and Robert Tibshirani",
    year             = "2010",
    journal          = "Journal of Statistical Software",
    volume           = "33",
    number           = "1",
    pages            = "1--22",
    doi              = "10.18637/jss.v033.i01"
  ),
  hechenbichler_2004 = bibentry("techreport",
    title            = "Weighted k-nearest-neighbor techniques and ordinal classification",
    author           = "Hechenbichler, Klaus and Schliep, Klaus",
    year             = "2004",
    number           = "Discussion Paper 399, SFB 386",
    doi              = "10.5282/ubm/epub.1769",
    institution      = "Ludwig-Maximilians University Munich"
  ),
  ripley_1996        = bibentry("book",
    doi              = "10.1017/cbo9780511812651",
    year             = "1996",
    month            = "jan",
    publisher        = "Cambridge University Press",
    author           = "Brian D. Ripley",
    title            = "Pattern Recognition and Neural Networks"
  ),
  roustant_2012      = bibentry("article",
    title            = "{DiceKriging}, {DiceOptim}: Two {R} Packages for the Analysis of Computer Experiments by Kriging-Based Metamodeling and Optimization",
    author           = "Olivier Roustant and David Ginsbourger and Yves Deville",
    year             = "2012",
    journal          = "Journal of Statistical Software",
    volume           = "51",
    number           = "1",
    pages            = "1--55",
    doi              = "10.18637/jss.v051.i01"
  ),
  samworth_2012      = bibentry("article",
    title            = "Optimal weighted nearest neighbour classifiers",
    author           = "Samworth, Richard J",
    year             = "2012",
    journal          = "The Annals of Statistics",
    volume           = "40",
    number           = "5",
    pages            = "2733--2763",
    doi              = "10.1214/12-AOS1049"
  ),
  venables_2002      = bibentry("book",
    title            = "Modern Applied Statistics with S",
    author           = "W. N. Venables and B. D. Ripley",
    year             = "2002",
    publisher        = "Springer",
    address          = "New York",
    url              = "http://www.stats.ox.ac.uk/pub/MASS4/",
    note             = "ISBN 0-387-95457-0",
    edition          = "Fourth"
  ),
  wright_2017        = bibentry("article",
    title            = "{ranger}: A Fast Implementation of Random Forests for High Dimensional Data in {C++} and {R}",
    author           = "Wright, Marvin N. and Ziegler, Andreas",
    year             = "2017",
    journal          = "Journal of Statistical Software",
    volume           = "77",
    number           = "1",
    pages            = "1--17",
    doi              = "10.18637/jss.v077.i01"
  )
) # nolint end
