% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrRanger.R
\name{mlr_learners_regr.ranger}
\alias{mlr_learners_regr.ranger}
\alias{LearnerRegrRanger}
\title{Ranger Regression Learner}
\description{
Random regression forest.
Calls \code{\link[ranger:ranger]{ranger::ranger()}} from package \CRANpkg{ranger}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.ranger")
lrn("regr.ranger")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

, * Task type: \dQuote{regr}, * Predict Types: \dQuote{response}, \dQuote{se}, * Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}, * Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{ranger}
}

\section{Parameters}{

, |Id                           |Type      |Default  |Levels                                          |Range                                |, |:----------------------------|:---------|:--------|:-----------------------------------------------|:------------------------------------|, |alpha                        |numeric   |0.5      |                                                |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |always.split.variables       |untyped   |-        |                                                |-                                    |, |holdout                      |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |importance                   |character |-        |none, impurity, impurity_corrected, permutation |-                                    |, |keep.inbag                   |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |max.depth                    |integer   |NULL     |                                                |\eqn{[0, \infty)}{[0, Inf)}          |, |min.node.size                |integer   |5        |                                                |\eqn{[1, \infty)}{[1, Inf)}          |, |min.prop                     |numeric   |0.1      |                                                |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |minprop                      |numeric   |0.1      |                                                |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |mtry                         |integer   |-        |                                                |\eqn{[1, \infty)}{[1, Inf)}          |, |mtry.ratio                   |numeric   |-        |                                                |\eqn{[0, 1]}{[0, 1]}                 |, |num.random.splits            |integer   |1        |                                                |\eqn{[1, \infty)}{[1, Inf)}          |, |num.threads                  |integer   |1        |                                                |\eqn{[1, \infty)}{[1, Inf)}          |, |num.trees                    |integer   |500      |                                                |\eqn{[1, \infty)}{[1, Inf)}          |, |oob.error                    |logical   |TRUE     |TRUE, FALSE                                     |-                                    |, |quantreg                     |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |regularization.factor        |untyped   |1        |                                                |-                                    |, |regularization.usedepth      |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |replace                      |logical   |TRUE     |TRUE, FALSE                                     |-                                    |, |respect.unordered.factors    |character |ignore   |ignore, order, partition                        |-                                    |, |sample.fraction              |numeric   |-        |                                                |\eqn{[0, 1]}{[0, 1]}                 |, |save.memory                  |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |scale.permutation.importance |logical   |FALSE    |TRUE, FALSE                                     |-                                    |, |se.method                    |character |infjack  |jack, infjack                                   |-                                    |, |seed                         |integer   |NULL     |                                                |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |split.select.weights         |untyped   |         |                                                |-                                    |, |splitrule                    |character |variance |variance, extratrees, maxstat                   |-                                    |, |verbose                      |logical   |TRUE     |TRUE, FALSE                                     |-                                    |, |write.forest                 |logical   |TRUE     |TRUE, FALSE                                     |-                                    |
}

\section{Custom mlr3 defaults}{

\itemize{
\item \code{num.threads}:
\itemize{
\item Actual default: \code{NULL}, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
\item \code{mtry}:
\itemize{
\item This hyperparameter can alternatively be set via our hyperparameter \code{mtry.ratio}
as \code{mtry = max(ceiling(mtry.ratio * n_features), 1)}.
Note that \code{mtry} and \code{mtry.ratio} are mutually exclusive.
}
}
}

\examples{
if (requireNamespace("ranger", quietly = TRUE)) {
  learner = mlr3::lrn("regr.ranger")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Wright, N. M, Ziegler, Andreas (2017).
\dQuote{ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R.}
\emph{Journal of Statistical Software}, \bold{77}(1), 1--17.
\doi{10.18637/jss.v077.i01}.

Breiman, Leo (2001).
\dQuote{Random Forests.}
\emph{Machine Learning}, \bold{45}(1), 5--32.
ISSN 1573-0565, \doi{10.1023/A:1010933404324}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrRanger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrRanger-new}{\code{LearnerRegrRanger$new()}}
\item \href{#method-LearnerRegrRanger-importance}{\code{LearnerRegrRanger$importance()}}
\item \href{#method-LearnerRegrRanger-oob_error}{\code{LearnerRegrRanger$oob_error()}}
\item \href{#method-LearnerRegrRanger-clone}{\code{LearnerRegrRanger$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
Parameter \code{importance.mode} must be set to \code{"impurity"}, \code{"impurity_corrected"}, or
\code{"permutation"}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-oob_error"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-oob_error}{}}}
\subsection{Method \code{oob_error()}}{
The out-of-bag error, extracted from model slot \code{prediction.error}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$oob_error()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{numeric(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
