% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionStochasticCB.R
\name{mlr_acqfunctions_stochastic_cb}
\alias{mlr_acqfunctions_stochastic_cb}
\alias{AcqFunctionStochasticCB}
\title{Acquisition Function Stochastic Confidence Bound}
\description{
Lower / Upper Confidence Bound with lambda sampling and decay.
The initial \eqn{\lambda} is drawn from an uniform distribution between \code{min_lambda} and \code{max_lambda} or from an exponential distribution with rate \code{1 / lambda}.
\eqn{\lambda} is updated after each update by the formula \code{lambda * exp(-rate * (t \%\% period))}, where \code{t} is the number of times the acquisition function has been updated.

While this acquisition function usually would be used within an asynchronous optimizer, e.g., \link{OptimizerAsyncMbo},
it can in principle also be used in synchronous optimizers, e.g., \link{OptimizerMbo}.
}
\section{Dictionary}{

This \link{AcqFunction} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_acqfunctions} or with the associated sugar function \code{\link[=acqf]{acqf()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_acqfunctions$get("stochastic_cb")
acqf("stochastic_cb")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\itemize{
\item \code{"lambda"} (\code{numeric(1)})\cr
\eqn{\lambda} value for sampling from the exponential distribution.
Defaults to \code{1.96}.
\item \code{"min_lambda"} (\code{numeric(1)})\cr
Minimum value of \eqn{\lambda}for sampling from the uniform distribution.
Defaults to \code{0.01}.
\item \code{"max_lambda"} (\code{numeric(1)})\cr
Maximum value of \eqn{\lambda} for sampling from the uniform distribution.
Defaults to \code{10}.
\item \code{"distribution"} (\code{character(1)})\cr
Distribution to sample \eqn{\lambda} from.
One of \code{c("uniform", "exponential")}.
Defaults to \code{uniform}.
\item \code{"rate"} (\code{numeric(1)})\cr
Rate of the exponential decay.
Defaults to \code{0} i.e. no decay.
\item \code{"period"} (\code{integer(1)})\cr
Period of the exponential decay.
Defaults to \code{NULL}, i.e., the decay has no period.
}
}

\section{Note}{

\itemize{
\item This acquisition function always also returns its current (\code{acq_lambda}) and original (\code{acq_lambda_0}) \eqn{\lambda}.
These values will be logged into the \link[bbotk:ArchiveBatch]{bbotk::ArchiveBatch} of the \link[bbotk:OptimInstanceBatch]{bbotk::OptimInstanceBatch} of the \link{AcqOptimizer} and
therefore also in the \link[bbotk:Archive]{bbotk::Archive} of the actual \link[bbotk:OptimInstance]{bbotk::OptimInstance} that is to be optimized.
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(learner, archive = instance$archive)

  acq_function = acqf("stochastic_cb", surrogate = surrogate, lambda = 3)

  acq_function$surrogate$update()
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Snoek, Jasper, Larochelle, Hugo, Adams, P R (2012).
\dQuote{Practical Bayesian Optimization of Machine Learning Algorithms.}
In Pereira F, Burges CJC, Bottou L, Weinberger KQ (eds.), \emph{Advances in Neural Information Processing Systems}, volume 25, 2951--2959.
\item Egelé, Romain, Guyon, Isabelle, Vishwanath, Venkatram, Balaprakash, Prasanna (2023).
\dQuote{Asynchronous Decentralized Bayesian Optimization for Large Scale Hyperparameter Optimization.}
In \emph{2023 IEEE 19th International Conference on e-Science (e-Science)}, 1--10.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_ei_log}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_multi}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}},
\code{\link{mlr_acqfunctions_stochastic_ei}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionStochasticCB}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionStochasticCB-new}{\code{AcqFunctionStochasticCB$new()}}
\item \href{#method-AcqFunctionStochasticCB-update}{\code{AcqFunctionStochasticCB$update()}}
\item \href{#method-AcqFunctionStochasticCB-reset}{\code{AcqFunctionStochasticCB$reset()}}
\item \href{#method-AcqFunctionStochasticCB-clone}{\code{AcqFunctionStochasticCB$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticCB-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticCB-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticCB$new(
  surrogate = NULL,
  lambda = 1.96,
  min_lambda = 0.01,
  max_lambda = 10,
  distribution = "uniform",
  rate = 0,
  period = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearner}).}

\item{\code{lambda}}{(\code{numeric(1)}).}

\item{\code{min_lambda}}{(\code{numeric(1)}).}

\item{\code{max_lambda}}{(\code{numeric(1)}).}

\item{\code{distribution}}{(\code{character(1)}).}

\item{\code{rate}}{(\code{numeric(1)}).}

\item{\code{period}}{(\code{NULL} | \code{integer(1)}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticCB-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticCB-update}{}}}
\subsection{Method \code{update()}}{
Update the acquisition function.
Samples and decays lambda.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticCB$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticCB-reset"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticCB-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the acquisition function.
Resets the private update counter \code{.t} used within the epsilon decay.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticCB$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionStochasticCB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionStochasticCB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionStochasticCB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
