% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enframe.R
\name{enframe}
\alias{enframe}
\title{Convert a Named Vector Into A data.table}
\usage{
enframe(x, name = "name", value = "value")
}
\arguments{
\item{x}{(\code{vector()})\cr
Vector to convert to a \code{\link[data.table:data.table]{data.table::data.table()}}.}

\item{name}{(\code{character(1)})\cr
Name for the first column with names.}

\item{value}{(\code{character(1)})\cr
Name for the second column with values.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with two columns:
The names of \code{x} (or \code{seq_along(x)} if unnamed) and the values of \code{x}.
}
\examples{
x = 1:3
enframe(x)

x = set_names(1:3, letters[1:3])
enframe(x, value = "x_values")
}
