% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crate.R
\name{crate}
\alias{crate}
\title{Isolate a Function from its Environment}
\usage{
crate(.fn, ..., .parent = .GlobalEnv)
}
\arguments{
\item{.fn}{(\verb{function()})\cr
function to crate}

\item{...}{(any)\cr
The objects, which should be visible inside \code{.fn}.}

\item{.parent}{(\code{environment})\cr
Parent environment to look up names. Default so the global environment.}
}
\description{
Put a function in a "lean" environment that does not carry unnecessary baggage with it (e.g. references to datasets).
}
\examples{
meta_f = function(z) {
  x = 1
  y = 2
  crate(function() {
    c(x, y, z)
  }, x)
}
x = 100
y = 200
z = 300
f = meta_f(1)
f()
}
