% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_vector.R
\name{reorder_vector}
\alias{reorder_vector}
\title{Reorder Vector According to Second Vector}
\usage{
reorder_vector(x, y, na_last = NA)
}
\arguments{
\item{x}{(\verb{vector())}.}

\item{y}{(\code{vector()}).}

\item{na_last}{(\code{logical(1)})\cr
What to do with values in \code{x} which are not in \code{y}?
\itemize{
\item \code{NA}: Extra values are removed.
\item \code{FALSE}: Extra values are moved to the beginning of the new vector.
\item \code{TRUE}: Extra values are moved to the end of the new vector.
}}
}
\value{
(\code{integer()}).
}
\description{
Returns an integer vector to order vector \code{x} according to vector \code{y}.
}
\examples{
# x subset of y
x = c("b", "a", "c", "d")
y = letters
x[reorder_vector(x, y)]

# y subset of x
y = letters[1:3]
x[reorder_vector(x, y)]
x[reorder_vector(x, y, na_last = TRUE)]
x[reorder_vector(x, y, na_last = FALSE)]
}
