% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLObject.R
\name{oml_object}
\alias{oml_object}
\alias{OMLObject}
\title{Abstract Base Class for OpenML objects.}
\description{
All OML Objects inherit from this class.
Don't use his class directly.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{desc}}{(\code{list()})\cr
Description of OpenML object.}

\item{\code{cache_dir}}{(\code{logical(1)} | \code{character(1)})\cr
Stores the location of the cache for objects retrieved from OpenML.
If set to \code{FALSE}, caching is disabled.
Objects from the test server are stored in the subdirectory 'test', those from the public
server are stored in the subdirectory 'public'.

The package \CRANpkg{qs} is required for caching.}

\item{\code{id}}{(\code{integer(1)})\cr
OpenML data id.}

\item{\code{server}}{(\code{character(1)})\cr
The server for this object.}

\item{\code{man}}{(\code{character(1)})\cr
The manual entry.}

\item{\code{name}}{(\code{character(1)})\cr
The name of the object.}

\item{\code{type}}{(\code{character()})\cr
The type of OpenML object (e.g. task, run, ...).}

\item{\code{test_server}}{(\code{logical(1)})\cr
Whether the object is using the test server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMLObject-new}{\code{OMLObject$new()}}
\item \href{#method-OMLObject-help}{\code{OMLObject$help()}}
\item \href{#method-OMLObject-clone}{\code{OMLObject$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMLObject-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLObject$new(id, test_server = test_server_default(), type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{\code{test_server}}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}

\item{\code{type}}{(\code{charcater()})\cr
The type of OpenML object (e.g. run, task, ...).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLObject-help"></a>}}
\if{latex}{\out{\hypertarget{method-OMLObject-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLObject$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMLObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
