% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvMboost.R
\name{LearnerSurvMboost}
\alias{LearnerSurvMboost}
\alias{mlr_learners_surv.mboost}
\title{Gradient Boosting for Generalized Additive Models Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[mboost:mboost]{mboost::mboost()}}.
\itemize{
\item lp is predicted by \code{\link[mboost:predict.mboost]{mboost::predict.mboost()}}
\item distr is predicted by \code{\link[mboost:survFit]{mboost::survFit()}} which assumes a PH fit with a Breslow estimator
\item \code{crank} is identical to \code{lp}
}

The \code{dist} parameter is specified slightly differently than in \link{mboost}. Whereas the latter
takes in objects, in this learner instead a string is specified in order to identify which distribution
to use. As the default in \link{mboost} is the Gaussian family, which is not compatible with
survival models, instead we have by default \code{"coxph"}.

If the value given to the \code{Family} parameter is "custom.family" then an object of class
\code{\link[mboost:Family]{mboost::Family()}} needs to be passed to the \code{custom.family} parameter.

The only difference between \link{LearnerSurvGamboost} and \link{LearnerSurvMboost} is that the latter function
allows one to specify default degrees of freedom for smooth effects specified via
\code{baselearner = "bbs"}. In all other cases, degrees of freedom need to be set manually via a
specific definition of the corresponding base-learner.
}
\section{Construction}{
\preformatted{LearnerSurvMboost$new()
mlr_learners$get("surv.mboost")
lrn("surv.mboost")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank, lp}
\item Feature Types: \verb{integer, numeric, factor, logical}
\item Packages: \CRANpkg{mboost} \CRANpkg{distr6} \CRANpkg{survival}
}
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = lrn("surv.mboost")
learner$param_set$values = mlr3misc::insert_named(learner$param_set$values,
    list(center = TRUE, baselearner = "bols"))
resampling = rsmp("cv", folds = 2)
resample(task, learner, resampling)
}
\references{
Peter Buehlmann and Bin Yu (2003), Boosting with the L2 loss: regression and classification.
Journal of the American Statistical Association, 98, 324–339.

Peter Buehlmann and Torsten Hothorn (2007),
Boosting algorithms: regularization, prediction and model fitting.
Statistical Science, 22(4), 477–505.

Thomas Kneib, Torsten Hothorn and Gerhard Tutz (2009),
Variable selection and model choice in geoadditive regression models,
Biometrics, 65(2), 626–634.

Matthias Schmid and Torsten Hothorn (2008),
Boosting additive models using component-wise P-splines as base-learners.
Computational Statistics \& Data Analysis, 53(2), 298–311.

Torsten Hothorn, Peter Buehlmann, Thomas Kneib, Mattthias Schmid and Benjamin Hofner (2010),
Model-based Boosting 2.0. Journal of Machine Learning Research, 11, 2109 – 2113.

Benjamin Hofner, Andreas Mayr, Nikolay Robinzonov and Matthias Schmid (2014).
Model-based Boosting in R: A Hands-on Tutorial Using the R Package mboost.
Computational Statistics, 29, 3–35.
\doi{10.1007/s00180-012-0382-5}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
