% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvSVM.R
\name{LearnerSurvSVM}
\alias{LearnerSurvSVM}
\alias{mlr_learners_surv.svm}
\title{Regression, Ranking and Hybrid Support Vector Machines Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survivalsvm:survivalsvm]{survivalsvm::survivalsvm()}}.
\itemize{
\item crank is predicted by \code{\link[survivalsvm:predict.survivalsvm]{survivalsvm::predict.survivalsvm()}}
}

Four possible SVMs can be implemented, dependent on the \code{type} parameter. These correspond
to predicting the survival time via regression (\code{regression}), predicting a continuous rank
(\code{vanbelle1}, \code{vanbelle2}), or a hybrid of the two (\code{hybrid}).
Whichever \code{type} is chosen determines how the \code{crank} predict type is calculated,
but in any case all can be considered a valid continuous ranking.

To be in line with the Van Belle papers and to prevent the learner crashing without
user-set parameters, the default \code{diff.meth} is set to \code{diffmeth3} with \code{gamma.mu} equal to 0.1.
}
\section{Construction}{
\preformatted{LearnerSurvSVM$new()
mlr_learners$get("surv.svm")
lrn("surv.svm")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \code{crank}
\item Feature Types: \verb{integer, numeric}
\item Packages: \CRANpkg{survivalsvm}
}
}

\references{
\cite{mlr3proba}{vanbelle_2010}

\cite{mlr3proba}{vanbelle_2011}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}}
}
\concept{survival learners}
