% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvMSESE.R
\name{MeasureSurvMSESE}
\alias{MeasureSurvMSESE}
\alias{mlr_measures_surv.mseSE}
\title{Standard Error of Mean Squared Error Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{MeasureSurv}.}
\description{


Calculates the standard error of \link{MeasureSurvMSE}.

The standard error of the MSE, L, is approximated via
\deqn{se(L) = sd(L)/\sqrt{N}}{se(L) = sd(L)/\sqrt N}

Censored observations in the test set are ignored.
}
\section{Construction}{
\preformatted{MeasureSurvMSESE$new()
mlr_measures$get("surv.mseSE")
msr("surv.mseSE")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvMAESE}},
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other response survival measures: 
\code{\link{MeasureSurvMAESE}},
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}}
}
\concept{response survival measures}
\concept{survival measures}
