% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpPredSurvRegr.R
\name{mlr_pipeops_trafopred_survregr}
\alias{mlr_pipeops_trafopred_survregr}
\alias{PipeOpPredSurvRegr}
\title{PipeOpPredSurvRegr}
\description{
Transform \link{PredictionSurv} to \link{PredictionRegr}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpPredTransformer}.

The output is the input \link{PredictionSurv} transformed to a \link{PredictionRegr}. Censoring is ignored.
\code{crank} and \code{lp} predictions are also ignored.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \link{PipeOpPredTransformer}.
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)
  library(survival)

  # simple example
  pred = PredictionSurv$new(row_ids = 1:10, truth = Surv(1:10, rbinom(10, 1, 0.5)),
    response = 1:10)
  po = po("trafopred_survregr")
  new_pred = po$predict(list(pred = pred))[[1]]
  print(new_pred)
}
}
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}},
\code{\link{PipeOpTransformer}},
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafotask_regrsurv}},
\code{\link{mlr_pipeops_trafotask_survregr}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafotask_regrsurv}},
\code{\link{mlr_pipeops_trafotask_survregr}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3proba:PipeOpTransformer]{mlr3proba::PipeOpTransformer}} -> \code{\link[mlr3proba:PipeOpPredTransformer]{mlr3proba::PipeOpPredTransformer}} -> \code{PipeOpPredSurvRegr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpPredSurvRegr$new()}}
\item \href{#method-clone}{\code{PipeOpPredSurvRegr$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredSurvRegr$new(id = "trafopred_survregr")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredSurvRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
