% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorCombo.R
\name{mlr_terminators_combo}
\alias{mlr_terminators_combo}
\alias{TerminatorCombo}
\title{Combine Terminators}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
This class takes multiple \link{Terminator}s and terminates as soon as one or all of the included terminators are positive.
}
\section{Construction}{
\preformatted{TerminatorCombo$new(terminators = list(TerminatorNone$new()))
term("combo")
}
\itemize{
\item \code{terminators} :: \code{list()}\cr
List of objects of class \link{Terminator}.
}
}

\section{Parameters}{

\itemize{
\item \code{any} :: \code{logical(1)}\cr
Terminate iff any included terminator is positive? (not all), default is `TRUE.
}
}

\examples{
term("combo",
  list(term("model_time", secs = 60), term("evals", n_evals = 10)),
  any = FALSE
)
}
\seealso{
Other Terminator: 
\code{\link{Terminator}},
\code{\link{mlr_terminators_clock_time}},
\code{\link{mlr_terminators_evals}},
\code{\link{mlr_terminators_model_time}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_stagnation}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
