% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerFromOptimizer.R
\name{TunerFromOptimizer}
\alias{TunerFromOptimizer}
\title{TunerFromOptimizer}
\description{
Internally used to transform \link[bbotk:Optimizer]{bbotk::Optimizer} to \link{Tuner}.
}
\keyword{internal}
\section{Super class}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{TunerFromOptimizer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerFromOptimizer-new}{\code{TunerFromOptimizer$new()}}
\item \href{#method-TunerFromOptimizer-optimize}{\code{TunerFromOptimizer$optimize()}}
\item \href{#method-TunerFromOptimizer-clone}{\code{TunerFromOptimizer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerFromOptimizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerFromOptimizer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerFromOptimizer$new(optimizer, man = NA_character_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optimizer}}{\link[bbotk:Optimizer]{bbotk::Optimizer}\cr
Optimizer that is called.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerFromOptimizer-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-TunerFromOptimizer-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceSingleCrit} /
\link{TuningInstanceMultiCrit} until termination. The single evaluations and
the final results will be written into the \link{ArchiveTuning} that
resides in the \link{TuningInstanceSingleCrit}/\link{TuningInstanceMultiCrit}.
The final result is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerFromOptimizer$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceSingleCrit} | \link{TuningInstanceMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerFromOptimizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerFromOptimizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerFromOptimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
