% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMBOInfillCrit.R, R/zzz.R
\name{makeMBOInfillCrit}
\alias{makeMBOInfillCrit}
\alias{MBOInfillCrit}
\alias{crit.ei}
\alias{crit.mr}
\alias{crit.se}
\alias{crit.cb}
\alias{crit.cb1}
\alias{crit.cb2}
\alias{crit.aei}
\alias{crit.eqi}
\alias{crit.dib1}
\title{Create an infill criterion.}
\usage{
makeMBOInfillCrit(fun, name, id, opt.direction = "minimize",
  components = character(0L), params = list(), requires.se = FALSE)
}
\arguments{
\item{fun}{[\code{function(points, models, control, par.set, design, iter)}]\cr
 A function which expects the following parameters in exactly this order
 and return a numeric vector of criteria values at the points:
 \describe{
   \item{points [\code{data.frame}]}{n points where to evaluate.}
   \item{models [\code{\link[mlr]{WrappedModel}} | \code{list}]}{Model(s) fitted on design.}
   \item{control [\code{MBOControl}]}{Control object.}
   \item{par.set [\code{ParamSet}]}{Parameter set.}
   \item{design [\code{data.frame}]}{Design of already visited points.}
   \item{iter [\code{integer(1)}]}{Current iteration.}
   \item{attributes [\code{logical{1}}]}{Are there attributes appended to the return
    value that should be added to the \code{OptPath}?}
 }
Important: Internally, this function will be minimized. So the proposals will be where this function is low.}

\item{name}{[\code{character(1)}]\cr
Full name of the criterion.}

\item{id}{[\code{character(1)}]\cr
Short name of the criterion.
Used internally and in plots.}

\item{opt.direction}{[\code{character(1)}]\cr
Only for visualization: Shall this criterion be plotted as if it were to be minimized (\code{minimize}), maximized (\code{maximize}) or is the direction the same as for the objective function (\code{objective})?
Default is \code{minimize}.}

\item{components}{[\code{character}]\cr
Infill criteria may not return proposed point(s) only. Additional
information can be returned by appending a named \code{list} \dQuote{crit.components}
to the returned value as an attribute.
The \code{components} argument takes a character vector of the names of the
meta information, i.e., the names of the named \dQuote{crit.components} list.
Default is the empty character vector.}

\item{params}{[\code{list}]\cr
Named list of parameters for the infill criterion. There values may be used
by \pkg{mlrMBO} internally.
Default is the empty list.}

\item{requires.se}{[\code{logical(1)}]\cr
Does the infill criterion require the regression learner to provide a standard
error estimation?
Default is \code{FALSE}.}
}
\value{
[\code{\link{MBOInfillCrit}}]
}
\description{
The infill criterion guides the model based search process.
The most prominent infill criteria, e.g., expected improvement, lower
confidence bound and others, are already implemented in mlrMBO. Moreover,
the package allows for the creation of custom infill criteria.
}
\section{Predefined standard infill criteria}{

\describe{
\item{crit.ei}{Expected Improvement}
\item{crit.mr}{Mean response}
\item{crit.se}{Standard error}
\item{crit.cb}{Confidence bound with lambda automatically chosen, see \code{\link{infillcrits}}}
\item{crit.cb1}{Confidence bound with lambda=1}
\item{crit.cb2}{Confidence bound with lambda=2}
\item{crit.aei}{Augmented expected improvement}
\item{crit.eqi}{Expected quantile improvement}
\item{crit.dib1}{Direct indicator-based with lambda=1}
}
}

