% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMBOLearner.R
\name{makeMBOLearner}
\alias{makeMBOLearner}
\alias{mbo_default_learner}
\title{Generate default learner.}
\usage{
makeMBOLearner(control, fun, config = list(), ...)
}
\arguments{
\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{fun}{[\code{smoof_function}] \cr
The same objective function which is also passed to \code{\link{mbo}}.}

\item{config}{[\code{named list}] \cr
Named list of config option to overwrite global settings set via \code{\link[mlr]{configureMlr}} for this specific learner.}

\item{...}{[any]\cr
Further parameters passed to the constructed learner.
Will overwrite mlrMBO's defaults.}
}
\value{
[\code{Learner}]
}
\description{
This is a helper function that generates a default surrogate, based on properties of the objective
function and the selected infill criterion.

For numeric-only (including integers) parameter spaces without any dependencies:
\itemize{
\item{A Kriging model \dQuote{regr.km} with kernel \dQuote{matern3_2} is created.}
\item{If the objective function is deterministic we add a small nugget effect (10^-8*Var(y),
  y is vector of observed outcomes in current design) to increase numerical stability to
  hopefully prevent crashes of DiceKriging.}
\item{If the objective function is noisy the nugget effect will be estimated with
  \code{nugget.estim = TRUE} (but you can override this in \code{...}.}
  Also \code{jitter} is set to \code{TRUE} to circumvent a problem with DiceKriging where already
  trained input values produce the exact trained output.
  For further information check the \code{$note} slot of the created learner.
\item{Instead of the default \code{"BFGS"} optimization method we use rgenoud (\code{"gen"}),
  which is a hybrid algorithm, to combine global search based on genetic algorithms and local search
  based on gradients.
  This may improve the model fit and will less frequently produce a constant surrogate model.
  You can also override this setting in \code{...}.}
}

For mixed numeric-categorical parameter spaces, or spaces with conditional parameters:
\itemize{
\item{A random regression forest \dQuote{regr.randomForest} with 500 trees is created.}
\item{The standard error of a prediction (if required by the infill criterion) is estimated
  by computing the jackknife-after-bootstrap.
  This is the \code{se.method = "jackknife"} option of the \code{\link[mlr]{regr.randomForest}},
  see this page for further info and alternatives.
  }
}

If additionally dependencies are in present in the parameter space, inactive conditional parameters
are represented by missing \code{NA} values in the training design data.frame.
We simply handle those with an imputation method, added to the random forest:
\itemize{
\item{If a numeric value is inactive, i.e., missing, it will be imputed by 2 times the
  maximum of observed values}
\item{If a categorical value is inactive, i.e., missing, it will be imputed by the
  special class label \code{"__miss__"}}
}
Both of these techniques make sense for tree-based methods and are usually hard to beat, see
Ding et.al. (2010).
}
\references{
Ding, Yufeng, and Jeffrey S. Simonoff. An investigation of missing data methods for
classification trees applied to binary response data.
Journal of Machine Learning Research 11.Jan (2010): 131-170.
}
