% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_test.R
\encoding{UTF-8}
\name{ml_test}
\alias{ml_test}
\title{multi-class classifier evaluation metrics based on a confusion matrix (contingency table)}
\usage{
ml_test(predicted, true, output.as.table = FALSE)
}
\arguments{
\item{predicted}{class labels predicted by the classifier model (a set of classes convertible into type factor with levels representing labels)}

\item{true}{true class labels (a set of classes convertible into type factor of the same length and with the same levels as predicted)}

\item{output.as.table}{the function returns all metrics except for \strong{accuracy} and \strong{error.rate} in a tabular format if this argument is set to \emph{TRUE}}
}
\value{
the function returns a list of following metrics:
  \item{ \strong{accuracy} }{ \emph{calculated as:} (TP+TN) / (TP+FP+TN+FN) \emph{(doesn't show up when output.as.table = TRUE)}}
  \item{ \strong{balanced.accuracy} }{ \emph{calculated as:} (TP / (TP+FN)+TN / (TN+FP)) / 2 = (recall+specificity) / 2}
  \item{ \strong{DOR} }{ \emph{calculated as:}  TP*TN / (FP*FN) = L / lambda}
  \item{ \strong{error.rate} }{ \emph{calculated as:}  (FP+FN) / (TP+TN+FP+FN) = 1-accuracy \emph{(doesn't show up when output.as.table = TRUE)}}
  \item{ \strong{F0.5} }{ \emph{calculated as:}  1.25*(recall*precision/(0.25*precision+recall))}
  \item{ \strong{F1} }{ \emph{calculated as:}  2*(precision*recall / (precision+recall))}
  \item{ \strong{F2} }{ \emph{calculated as:}  5*(precision*recall / (4*precision+recall))}
  \item{ \strong{FDR} }{ \emph{calculated as:}  1-precision}
  \item{ \strong{FNR} }{ \emph{calculated as:}  1-recall}
  \item{ \strong{FOR} }{ \emph{calculated as:}  1-NPV}
  \item{ \strong{FPR} }{ \emph{calculated as:}  1-specificity}
  \item{ \strong{geometric.mean} }{ \emph{calculated as:}  (recall*specificity)^0.5}
  \item{ \strong{Jaccard} }{ \emph{calculated as:}  TP / (TP+FP+FN)}
  \item{ \strong{L} }{ \emph{calculated as:}  recall / (1-specificity)}
  \item{ \strong{lambda} }{ \emph{calculated as:}  (1-recall) / (specificity)}
  \item{ \strong{MCC} }{ \emph{calculated as:}  (TP*TN-FP*FN) / (((TP+FP)*(TP+FN)*(TN+FP)*(TN+FN))^0.5)}
  \item{ \strong{MK} }{ \emph{calculated as:}  precision + NPV - 1}
  \item{ \strong{NPV} }{ \emph{calculated as:}  TN / (TN+FN)}
  \item{ \strong{OP} }{ \emph{calculated as:}  accuracy - |recall-specificity| / (recall+specificity)}
  \item{ \strong{precision} }{ \emph{calculated as:} TP / (TP+FP)}
  \item{ \strong{recall} }{ \emph{calculated as:}  TP / (TP+FN)}
  \item{ \strong{specificity} }{ \emph{calculated as:}  TN / (TN+FP)}
  \item{ \strong{Youden} }{ \emph{calculated as:}  recall+specificity-1}
}
\description{
Calculates multi-class classification evaluation metrics: \strong{balanced.accuracy}, balanced accuracy (\strong{balanced.accuracy}),
diagnostic odds ratio (\strong{DOR}), error rate (\strong{error.rate}), F.beta (\strong{F0.5}, \strong{F1} (F-measure, F-score), \strong{F2} with where beta is 0.5, 1 and 2 respectively),
false positive rate (\strong{FPR}), false negative rate (\strong{FNR}), false omission rate ((\strong{FOR})), false discovery rate (\strong{FDR}),
geometric mean (\strong{geometric.mean}), \strong{Jaccard}, positive likelihood ratio (p+, LR(+) or simply \strong{L}),
negative likelihood ratio (p-, LR(-) or simply \strong{lambda}),  Matthews corellation coefficient (\strong{MCC}), markedness (\strong{MK}), negative predictive value (\strong{NPV}),
optimization precision \strong{OP}, \strong{precision}, \strong{recall} (sensitivity), \strong{specificity} and finally \strong{Youden}'s index.
The function calculates the aforementioned metrics from a confusion matrix (contingency matrix)
where \emph{TP}, \emph{TN}, \emph{FP} \emph{FN} are abbreviations for \emph{true positives}, \emph{true negatives},
\emph{false positives} and \emph{false negatives} respectively.
}
\examples{
library(mltest)

# class labels ("cat, "dog" and "rat") predicted by the classifier model
predicted_labels <- as.factor(c("dog", "cat", "dog", "rat", "rat"))

# true labels (test set)
true_labels <- as.factor(c("dog", "cat", "dog", "rat", "dog"))

classifier_metrics <- ml_test(predicted_labels, true_labels, output.as.table = FALSE)

# overall classification accuracy
accuracy <- classifier_metrics$accuracy

# F1-measures for classes "cat", "dog" and "rat"
F1 <- classifier_metrics$F1

# tabular view of the metrics (except for 'accuracy' and 'error.rate')
classifier_metrics <- ml_test(predicted_labels, true_labels, output.as.table = TRUE)

}
\references{
\enumerate{
  \item Sasaki Y. (2007). The truth of the F-measure.:1–5. \url{https://www.researchgate.net/publication/268185911_The_truth_of_the_F-measure}.
  \item Powers DMW. (2011). Evaluation: from Precision, Recall and F-measure to ROC, Informedness, Markedness & Correlation. Arch Geschwulstforsch. 2(1):37–63. \url{https://www.researchgate.net/publication/313610493_Evaluation_From_precision_recall_and_fmeasure_to_roc_informedness_markedness_and_correlation}.
  \item Bekkar M, Djemaa HK, Alitouche TA. (2013). Evaluation Measures for Models Assessment over Imbalanced Data Sets. J Inf Eng Appl. 3(10):27–38. \url{https://www.iiste.org/Journals/index.php/JIEA/article/view/7633}.
  \item Jeni LA, Cohn JF, De La Torre F. (2013). Facing Imbalanced Data Recommendations for the Use of Performance Metrics. Conference on Affective Computing and Intelligent Interaction. IEEE. p. 245–51. \url{http://ieeexplore.ieee.org/document/6681438/}.
  \item López V, Fernández A, García S, Palade V, Herrera F. (2013). An insight into classification with imbalanced data: Empirical results and current trends on using data intrinsic characteristics. Inf Sci. 250:113–41. \url{http://dx.doi.org/10.1016/j.ins.2013.07.007}.
  \item Tharwat A. (2018). Classification assessment methods. Appl Comput Informatics . \url{https://linkinghub.elsevier.com/retrieve/pii/S2210832718301546}.
}
}
\author{
G. Dudnik
}
\keyword{utilities}
