% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/catplotmlx.R
\name{catplotmlx}
\alias{catplotmlx}
\title{Plot Categorical Longitudinal Data}
\usage{
catplotmlx(r, breaks = NULL)
}
\arguments{
\item{r}{a data frame with a column \samp{id}, a column \samp{time},
a column with values and possibly a column \samp{group}.}

\item{breaks}{one of:
\itemize{
  \item a vector giving the breakpoints,
  \item a single number giving the number of segments.
}}
}
\description{
Plot the empirical distribution of categorical longitudinal data.
}
\details{
See http://simulx.webpopix.org/mlxr/catplotmlx/ for more details.
}
\examples{
\dontrun{
  catModel <- inlineModel("
  [LONGITUDINAL]
  input =  {a,b}
  EQUATION:
  lp1=a-b*t
  lp2=a-b*t/2
  DEFINITION:
  y = {type=categorical, categories={1,2,3},
  logit(P(y<=1))=lp1, logit(P(y<=2))=lp2}
  ")

  p1  <- c(a=8,b=0.2)
  y  <- list(name='y', time=seq(0, 100, by=4))
  g1 <- list(size=100, parameter=p1)
  res <- simulx(model=catModel, output=y, group=g1)
  plot1 <- catplotmlx(res$y)
  print(plot1)

  plot2 <- catplotmlx(res$y,breaks=seq(-2,102,by=8))
  print(plot2)

  plot3 <- catplotmlx(res$y,breaks=5)
  print(plot3)

  p2  <- c(a=6,b=0.3)
  g2 <- list(size=100, parameter=p2)
  res <- simulx(model=catModel, output=y, group=list(g1,g2))
  plot4 <- catplotmlx(res$y)
  if( require("gridExtra") ){
    grid.arrange(plot4[[1]],plot4[[2]],ncol=2)
  }
}
}

