% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmib_model.R
\name{mmib_model}
\alias{mmib_model}
\title{Fit Statistical Models for MMI Bain Processing}
\usage{
mmib_model(
  formula = NULL,
  column_names = NULL,
  model = NULL,
  data,
  engine = c("lm", "t_test", "lavaan"),
  ...
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit. Used specifically
for the \code{lm} engine. Default is NULL.}

\item{column_names}{A character vector of length 2, representing the column
names to be used for the \code{t_test} engine. Default
is NULL.}

\item{model}{A model specification (usually as a string) for the \code{lavaan} engine.
Default is NULL.}

\item{data}{A data frame containing the variables in the model.}

\item{engine}{A character string representing the statistical method to be used.
Currently supported methods are: \code{"lm"}, \code{"t_test"}, and \code{"lavaan"}.}

\item{...}{Additional arguments to be passed to the underlying statistical
function (lm(), t.test(), or lavaan::sem()).}
}
\value{
Returns an object of the type associated with the engine selected (\code{lm},
\code{htest}, or \code{lavaan} object).
}
\description{
This function provides a unified interface to fit different statistical models
supported by the 'bain' package.
}
\details{
The mmib_model() function provides a simple interface to fit various statistical
models, which can be subsequently processed by the bain::bain() function. It
ensures that only one of \code{formula}, \code{column_names}, or \code{model} is provided,
checks the validity of the provided data, and selects the appropriate statistical
method based on the \code{engine} parameter.
}
\examples{
data(mtcars)

# Fit linear model
mod1 <- mmib_model(mpg ~ wt + qsec, data = mtcars, engine = "lm")

}
\seealso{
\code{\link[bain]{bain}} for processing the models fit with \code{mmib_model}.
}
