% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbc_game_mgmt.R
\name{deal_cards_to_grid}
\alias{deal_cards_to_grid}
\title{Deal Cards to Grid}
\usage{
deal_cards_to_grid(deck = mmcards::shuffle_deck(), n)
}
\arguments{
\item{deck}{A dataframe representing a deck of cards, with each row being a
a card. The parameter is designed to take mmcards::shuffle_deck() or
mmcards::i_deck() as input.}

\item{n}{A single integer representing the number of rows and columns in the
grid (i.e., the grid will be n x n). This parameter is required and
does not have a default value.}
}
\value{
A list containing two elements:
\itemize{
\item \code{cards_matrix}: an n x n matrix where each element is a list
representing a card.
\item \code{updated_deck}: a list representing the remaining deck after n^2
cards have been dealt.
}
}
\description{
This function deals n^2 cards from a specified or default deck to form
an n x n grid. The remaining deck is also returned alongside the grid.
}
\examples{
  # Dealing cards to a 2x2 grid using the default shuffled deck
  deal_cards_to_grid(n = 2)

}
