% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb.R
\name{h_mmrm_tmb_fit}
\alias{h_mmrm_tmb_fit}
\title{Build \code{TMB} Fit Result List}
\usage{
h_mmrm_tmb_fit(tmb_object, tmb_opt, data, weights, formula_parts, tmb_data)
}
\arguments{
\item{tmb_object}{(\code{list})\cr created with \code{\link[TMB:MakeADFun]{TMB::MakeADFun()}}.}

\item{tmb_opt}{(\code{list})\cr optimization result.}

\item{data}{(\code{data.frame})\cr input data containing the variables used
in \code{formula}.}

\item{weights}{(\code{vector})\cr weights to be used in the fitting process.}

\item{formula_parts}{(\code{mmrm_tmb_formula_parts})\cr produced by
\code{\link[=h_mmrm_tmb_formula_parts]{h_mmrm_tmb_formula_parts()}}.}

\item{tmb_data}{(\code{mmrm_tmb_data})\cr produced by \code{\link[=h_mmrm_tmb_data]{h_mmrm_tmb_data()}}.}
}
\value{
List of class \code{mmrm_tmb} with:
\itemize{
\item \code{cov}: estimated covariance matrix, or named list of estimated group specific covariance matrices.
\item \code{beta_est}: vector of coefficient estimates.
\item \code{beta_vcov}: Variance-covariance matrix for coefficient estimates.
\item \code{theta_est}: vector of variance parameter estimates.
\item \code{theta_vcov}: variance-covariance matrix for variance parameter estimates.
\item \code{neg_log_lik}: obtained negative log-likelihood.
\item \code{formula_parts}: input.
\item \code{data}: input.
\item \code{weights}: input.
\item \code{reml}: input as a flag.
\item \code{opt_details}: list with optimization details including convergence code.
\item \code{tmb_object}: original \code{TMB} object created with \code{\link[TMB:MakeADFun]{TMB::MakeADFun()}}.
\item \code{tmb_data}: input.
}
}
\description{
This helper does some simple post-processing of the \code{TMB} object and
optimization results, including setting names, inverting matrices etc.
}
\keyword{internal}
