% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interop-emmeans.R
\name{emmeans_support}
\alias{emmeans_support}
\title{Support for \code{emmeans}}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This package includes methods that allow \code{mmrm} objects to be used
with the \code{emmeans} package. \code{emmeans} computes estimated marginal means
(also called least-square means) for the coefficients of the MMRM.
We can also e.g. obtain differences between groups by applying
\code{\link[emmeans:contrast]{pairs()}} on the object returned
by \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.
}
\examples{
fit <- mmrm(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data
)
if (require(emmeans)) {
  emmeans(fit, ~ ARMCD | AVISIT)
  pairs(emmeans(fit, ~ ARMCD | AVISIT), reverse = TRUE)
}
}
