% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satterthwaite.R
\name{h_quad_form}
\alias{h_quad_form}
\alias{h_quad_form_vec}
\alias{h_quad_form_mat}
\title{Quadratic Form Calculations}
\usage{
h_quad_form_vec(vec, center)

h_quad_form_mat(mat, center)
}
\arguments{
\item{vec}{(\code{numeric})\cr interpreted as a row vector.}

\item{center}{(\code{matrix})\cr square numeric matrix with the same dimensions as
\code{x} as the center of the quadratic form.}

\item{mat}{(\code{matrix})\cr numeric matrix to be multiplied left and right of
\code{center}, therefore needs to have as many columns as there are rows and columns
in \code{center}.}
}
\description{
These helpers are mainly for easier readability and slightly better efficiency
of the quadratic forms used in the Satterthwaite calculations.
}
\section{Functions}{
\itemize{
\item \code{h_quad_form_vec()}: calculates the number \code{vec \%*\% center \%*\% t(vec)}
as a numeric (not a matrix).

\item \code{h_quad_form_mat()}: calculates the quadratic form \code{mat \%*\% center \%*\% t(mat)}
as a matrix, the result is square and has dimensions identical to the number
of rows in \code{mat}.

}}
\keyword{internal}
