% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{mm_VizShapespace}
\alias{mm_VizShapespace}
\title{Visualize PC axes}
\usage{
mm_VizShapespace(
  mmPCA,
  xPC = 1,
  yPC = 2,
  yr = c(0, 1.1),
  cols = NULL,
  title = "",
  png_dir = NULL
)
}
\arguments{
\item{mmPCA}{Output of \code{mm_CalcShapespace}, containing a PCA object with
PC shapes}

\item{xPC}{The PC to be plotted on the x axis. If yPC is left null, a
univariate density distribution will be plotted with min/max shapes.}

\item{yPC}{The PC to be plotted on the y axis.}

\item{yr}{The y-xis range, in the format c(0,1)}

\item{cols}{A vector of colors of length n, for use in scatterplot.}

\item{title}{To be used for the plot}

\item{png_dir}{A file path to a directory in which to save out PNG figures.
Names will be automatically assigned based on input PC(s).}
}
\value{
Produces a series of plots to visualize PCA analysis. If \code{png_dir} is
specified, function will save out \code{.png} files. Otherwise plots will be
displayed in the default plot window.
}
\description{
Plot a scatterplot and vizualize shape change across the X axis.
}
\details{
Meant to be a quick diagnostic plot with minimal customization.
}
