% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity_Area_Relationships.R
\name{div_rand_rect}
\alias{div_rand_rect}
\title{Distribution of local diversity indices}
\usage{
div_rand_rect(prop_area = 0.25, comm, n_rect = 100, exclude_zeros = F)
}
\arguments{
\item{prop_area}{Size of subplots as proportion of the total area}

\item{comm}{\code{\link{community}} object}

\item{n_rect}{Number of randomly located subplots}

\item{exclude_zeros}{Should subplots without individuals be excluded? (logical)}
}
\value{
Vector with mean and standard deviation of the following diversity
indices:

\enumerate{
   \item Number of species
   \item Number of endemics
   \item Shannon index
   \item Effective number of species (ENS) based on Shannon index
   \item Simpson index
   \item Effective number of species (ENS) based on Simpson index
}

See the documentation of  \code{\link{div_rect}} for detailed information on the
definition of the diversity indices.
}
\description{
Get mean and standard deviation of diversity indices in several equally
sized subplots of a community
}
\examples{
sim1 <- sim_poisson_community(100,1000)
div_rand_rect(prop_area = 0.1, comm = sim1)


}
