% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sample_quadrats.R
\name{sampling_random_bruteforce}
\alias{sampling_random_bruteforce}
\title{Creates coordinates (lower left corner of a quadrat) randomly distributed but without overlapping each
other}
\usage{
sampling_random_bruteforce(
  n_quadrats,
  min_dist,
  xmin,
  xmax,
  ymin,
  ymax,
  seed = NULL
)
}
\arguments{
\item{n_quadrats}{Number of sampling quadrats}

\item{min_dist}{(numeric) minimal distance between two points to avoid overlap.
Equal to the length of a quadrat diagonal}

\item{xmin}{(numeric) minimum possible value on the x axis a quadrat can cover.}

\item{xmax}{(numeric) maximum possible value on the x axis a quadrat can cover.}

\item{ymin}{(numeric) minimum possible value on the y axis a quadrat can cover.}

\item{ymax}{(numeric) maximum possible value on the y axis a quadrat can cover.}

\item{seed}{(integer) Any integer passed to \code{set.seed} for reproducibility.}
}
\value{
a data.frame with 2 columns x and y giving  the coordinates of the
lower left corner of the square quadrats.
}
\description{
This function works without having the \code{spatstat.random} package install.
}
