% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmtree-methods.R
\name{objfun.pmtree}
\alias{objfun.pmtree}
\title{Objective function of a given pmtree}
\usage{
\method{objfun}{pmtree}(x, newdata = NULL, weights = NULL, perm = NULL,
  sum = FALSE, ...)
}
\arguments{
\item{x}{pmtree object.}

\item{newdata}{an optional new data frame for which to compute the sum of 
objective functions.}

\item{weights}{weights.}

\item{perm}{the number of permutations performed (see \code{\link[partykit]{varimp}}).}

\item{sum}{should the sum of objective functions be computed.}

\item{...}{passed on to \code{\link[partykit]{predict.party}}.

Note that \code{objfun.pmtree(x, sum = TRUE)} is much faster than
\code{sum(objfun.pmtree(x))}.}
}
\value{
objective function or the sum thereof
}
\description{
Returns the contributions to the objective function or the 
sum thereof (if \code{sum = TRUE}).
}
\examples{
## generate data
set.seed(2)
n <- 1000
trt <- factor(rep(1:2, each = n/2))
age <- sample(40:60, size = n, replace = TRUE)
eff <- -1 + I(trt == 2) + 1 * I(trt == 2) * I(age > 50)
expit <- function(x) 1/(1 + exp(-x))
success <- rbinom(n = n, size = 1, prob = expit(eff))
dat <- data.frame(success, trt, age)

## compute base model
bmod1 <- glm(success ~ trt, data = dat, family = binomial)

## copmute tree
(tr1 <- pmtree(bmod1, data = dat))

## compute log-Likelihood
logLik(tr1)
objfun(tr1, newdata = dat, sum = TRUE)
objfun(tr1, sum = TRUE)

## log-Likelihood contributions of first 
## 5 observations
nd <- dat[1:5, ]
objfun(tr1, newdata = nd)
}
