% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_smooth.R
\name{estimate_smooth}
\alias{estimate_smooth}
\title{Describe the smooth term (for GAMs) or non-linear predictors}
\usage{
estimate_smooth(model, smooth = NULL, levels = NULL, ...)
}
\arguments{
\item{model}{A Bayesian model.}

\item{smooth}{A character indicating the name of the "smooth" term}

\item{levels}{A character vector indicating the variables over which the slope will be computed. If NULL (default), it will select all the remaining predictors.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of linear description of non-linear terms.
}
\description{
This function summarises the smooth term trend in terms of linear segments.
Using the aproximative derivative, it separates a non-linear vector into
quasi-linear segments (in which the trend is either positive or negative).
Each of this segment its characterized by its beginning, end, size (in
proportion, relative to the total size) trend (the linear regression
coefficient) and linearity (the R2 of the linear regression).
}
\examples{
library(modelbased)
\donttest{
if (require("rstanarm")) {
  model <- stan_gamm4(Sepal.Width ~ s(Petal.Length), data = iris, refresh = 0)
  estimate_smooth(model)

  model <- stan_glm(Sepal.Width ~ poly(Petal.Length, 2), data = iris)
  estimate_smooth(model)

  model <- stan_gamm4(Sepal.Width ~ Species + s(Petal.Length), data = iris)
  estimate_smooth(model)

  model <- stan_glm(Sepal.Width ~ Species * poly(Petal.Length, 2), data = iris)
  estimate_smooth(model)
  estimate_smooth(model, levels = "Species")
}
}
}
