% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-save_and_load.R
\name{save_h2o_model}
\alias{save_h2o_model}
\alias{load_h2o_model}
\title{Saving and Loading Modeltime H2O Models}
\usage{
save_h2o_model(object, path, overwrite = FALSE)

load_h2o_model(path)
}
\arguments{
\item{object}{A fitted model object}

\item{path}{A directory to store the H2O AutoML model files}

\item{overwrite}{Whether or not to allow overwriting a H2O AutoML model's directory. Default: FALSE.}
}
\value{
\itemize{
\item \code{save_h2o_model()}: No return value, called for side effects (composes a directory of model files)
\item \code{load_h2o_model()}: No return value, called for side effects (reads a directory of model files)
}
}
\description{
H2O AutoML models require a special storage process that saves / loads the
recipe used to recreate a model to / from a directory that the user
defines.
}
\examples{
\dontrun{
library(tidymodels)
library(tidyverse)
library(timetk)
library(modeltime.h2o)

h2o.init()

model_fit <- automl_reg(mode = 'regression') \%>\%
    set_engine(
        engine                     = 'h2o',
        max_runtime_secs           = 30, 
        max_runtime_secs_per_model = 30,
        project_name               = 'project_01',
        nfolds                     = 5,
        max_models                 = 1000,
        exclude_algos              = c("DeepLearning"),
        seed                       =  786
    ) \%>\%
    fit(value ~ date + id, m750)

# Saves the related files needed to recreate the model
model_fit \%>\% save_h2o_model(path = "/dir_h2o_automl_model/")

# Loads the model
load_h2o_model(path = "/dir_h2o_automl_model/")

# Shutdown H2O when Finished. 
# Make sure to save any work before. 
h2o.shutdown(prompt = FALSE)

}

}
