% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-prophet_reg.R
\name{prophet_fit_impl}
\alias{prophet_fit_impl}
\title{Low-Level PROPHET function for translating modeltime to PROPHET}
\usage{
prophet_fit_impl(
  x,
  y,
  growth = "linear",
  n.changepoints = 25,
  seasonality.mode = "additive",
  changepoint.prior.scale = 0.05,
  seasonality.prior.scale = 10,
  holidays.prior.scale = 10,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{growth}{String 'linear' or 'logistic' to specify a linear or logistic
trend.}

\item{n.changepoints}{Number of potential changepoints to include. Not used
if input `changepoints` is supplied. If `changepoints` is not supplied,
then n.changepoints potential changepoints are selected uniformly from the
first `changepoint.range` proportion of df$ds.}

\item{seasonality.mode}{'additive' (default) or 'multiplicative'.}

\item{changepoint.prior.scale}{Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.}

\item{seasonality.prior.scale}{Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality. Can be specified for
individual seasonalities using add_seasonality.}

\item{holidays.prior.scale}{Parameter modulating the strength of the holiday
components model, unless overridden in the holidays input.}

\item{...}{Additional arguments passed to \code{prophet::prophet}}
}
\description{
Low-Level PROPHET function for translating modeltime to PROPHET
}
