% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-prophet_params.R
\name{prophet_params}
\alias{prophet_params}
\alias{growth}
\alias{num_changepoints}
\alias{prior_scale_changepoints}
\alias{prior_scale_seasonality}
\alias{prior_scale_holidays}
\title{Tuning Parameters for Prophet Models}
\usage{
growth(values = c("linear", "logistic"))

num_changepoints(range = c(0L, 50L), trans = NULL)

prior_scale_changepoints(range = c(-3, 2), trans = log10_trans())

prior_scale_seasonality(range = c(-3, 2), trans = log10_trans())

prior_scale_holidays(range = c(-3, 2), trans = log10_trans())
}
\arguments{
\item{values}{A character string of possible values.}

\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Tuning Parameters for Prophet Models
}
\details{
The main parameters for Prophet models are:
\itemize{
\item \code{growth}: The form of the trend: "linear", or "logistic".
\item \code{num_changepoints}: The number of trend changepoints allowed in modeling the trend
\item \code{season}:
\itemize{
\item The form of the seasonal term: "additive" or "multiplicative".
\item See \code{\link[=season]{season()}}.
}
\item "Prior Scale": Controls flexibility of
\itemize{
\item \emph{Changepoints:} \code{prior_scale_changepoints}
\item \emph{Seasonality:} \code{prior_scale_seasonality}
\item \emph{Holidays:} \code{prior_scale_holidays}
\item The \code{log10_trans()} converts priors to a scale from 0.001 to 100,
which effectively weights lower values more heavily than larger values.
}
}
}
\examples{

growth()

num_changepoints()

season()

prior_scale_changepoints()

}
