% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-accuracy.R
\name{modeltime_accuracy}
\alias{modeltime_accuracy}
\title{Calculate Accuracy Metrics}
\usage{
modeltime_accuracy(
  object,
  new_data = NULL,
  metric_set = default_forecast_accuracy_metric_set(),
  quiet = TRUE,
  ...
)
}
\arguments{
\item{object}{A Modeltime Table}

\item{new_data}{A \code{tibble} to predict and calculate residuals on.
If provided, overrides any calibration data.}

\item{metric_set}{A \code{yardstick::metric_set()} that is used to summarize one or more
forecast accuracy (regression) metrics.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them as they occur?}

\item{...}{Not currently used}
}
\value{
A tibble with accuracy estimates.
}
\description{
This is a wrapper for \code{yardstick} that simplifies time series regression accuracy metric
calculations from a fitted \code{workflow} (trained workflow) or \code{model_fit} (trained parsnip model).
}
\details{
The following accuracy metrics are included by default via \code{\link[=default_forecast_accuracy_metric_set]{default_forecast_accuracy_metric_set()}}:
\itemize{
\item MAE - Mean absolute error, \code{\link[=mae]{mae()}}
\item MAPE - Mean absolute percentage error, \code{\link[=mape]{mape()}}
\item MASE  - Mean absolute scaled error, \code{\link[=mase]{mase()}}
\item SMAPE - Symmetric mean absolute percentage error, \code{\link[=smape]{smape()}}
\item RMSE  - Root mean squared error, \code{\link[=rmse]{rmse()}}
\item RSQ   - R-squared, \code{\link[=rsq]{rsq()}}
}
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: auto_arima ----
model_fit_arima <- arima_reg() \%>\%
    set_engine(engine = "auto_arima") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_arima
)

# ---- ACCURACY ----

models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_accuracy(
        metric_set = metric_set(mae, rmse, rsq)
    )


}
