% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-constructor.R
\name{new_modeltime_bridge}
\alias{new_modeltime_bridge}
\title{Constructor for creating modeltime models}
\usage{
new_modeltime_bridge(class, models, data, extras = NULL, desc = NULL)
}
\arguments{
\item{class}{A class name that is used for creating custom printing messages}

\item{models}{A list containing one or more models}

\item{data}{A data frame (or tibble) containing 4 columns:
(date column with name that matches input data), .actual, .fitted, and .residuals.}

\item{extras}{An optional list that is typically used for transferring preprocessing recipes
to the predict method.}

\item{desc}{An optional model description to appear when printing your modeltime objects}
}
\description{
These functions are used to construct new \code{modeltime} bridge functions that
connect the \code{tidymodels} infrastructure to time-series models containing date or date-time features.
}
\examples{
library(dplyr)
library(lubridate)
library(timetk)

lm_model <- lm(value ~ as.numeric(date) + hour(date) + wday(date, label = TRUE),
               data = taylor_30_min)

data = tibble(
    date        = taylor_30_min$date, # Important - The column name must match the modeled data
    # These are standardized names: .actual, .fitted, .residuals
    .actual     = taylor_30_min$value,
    .fitted     = lm_model$fitted.values \%>\% as.numeric(),
    .residuals  = lm_model$residuals \%>\% as.numeric()
)

new_modeltime_bridge(
    class  = "lm_time_series_impl",
    models = list(model_1 = lm_model),
    data   = data,
    extras = NULL
)


}
