% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/house_prices.R
\docType{data}
\name{house_prices}
\alias{house_prices}
\title{House Sales in King County, USA}
\format{A data frame with 21613 observations on the following 21 variables.
\describe{
  \item{id}{a notation for a house}
  \item{date}{Date house was sold}
  \item{price}{Price is prediction target}
  \item{bedrooms}{Number of Bedrooms/House}
  \item{bathrooms}{Number of bathrooms/bedrooms}
  \item{sqft_living}{square footage of the home}
  \item{sqft_lot}{square footage of the lot}
  \item{floors}{Total floors (levels) in house}
  \item{waterfront}{House which has a view to a waterfront}
  \item{view}{Has been viewed}
  \item{condition}{How good the condition is (Overall)}
  \item{grade}{overall grade given to the housing unit, based on King County grading system}
  \item{sqft_above}{square footage of house apart from basement}
  \item{sqft_basement}{square footage of the basement}
  \item{yr_built}{Built Year}
  \item{yr_renovated}{Year when house was renovated}
  \item{zipcode}{zip code}
  \item{lat}{Latitude coordinate}
  \item{long}{Longitude coordinate}
  \item{sqft_living15}{Living room area in 2015 (implies-- some renovations) This might or might not have affected the lotsize area}
  \item{sqft_lot15}{lotSize area in 2015 (implies-- some renovations)}
}}
\source{
Kaggle \url{https://www.kaggle.com/harlfoxem/housesalesprediction}. 
Note data is released under a CC0: Public Domain license.
}
\usage{
house_prices
}
\description{
This dataset contains house sale prices for King County, which includes 
Seattle. It includes homes sold between May 2014 and May 2015. This dataset
was obtained from Kaggle.com \url{https://www.kaggle.com/harlfoxem/housesalesprediction/data}
}
\examples{
library(dplyr)
library(ggplot2)

# Create variable log of house price
house_prices <- house_prices \%>\% 
  mutate(log_price = log(price))
  
# Plot histogram of log of house price
ggplot(house_prices, aes(x = log_price)) +
  geom_histogram()

}
\keyword{datasets}
