% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwmk.R
\name{pwmk}
\alias{pwmk}
\title{Mann-Kendall Test of Pre-Whitened Time Series Data in Presence of Serial Correlation Using Yue and Wang (2002) Approach.}
\usage{
pwmk(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z-Value  - Z-Statistic after variance Correction

Sen's Slope  - Sen's slope for Prewhitened series

old. Sen's Slope  - Sen's slope for Original data series 'x'

P-value  - P-Value after variance correction

S  - Mann-Kendall 'S'- statistic

Var(s) - Variance of 's'

Tau  - Mann-Kendall's Tau
}
\description{
When the time series data is not random and influenced by auto-correlation, Pre-Whitening the time series prior to application of trend test is suggested.
}
\details{
Pre-Whitening involves calculating lag-1 serial correlation coefficient and calculating new-series.
}
\examples{
x<-c(Nile)
pwmk(x)

}
\references{
Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245–259. <doi:10.1017/CBO9781107415324.004>

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

Sen, P. K. (1968). Estimates of the Regression Coefficient Based on Kendall’s Tau. Journal of the American Statistical Association, 63(324), 1379. <doi:10.2307/2285891>

Yue, S., & Wang, C. Y. (2002). Applicability of prewhitening to eliminate the influence of serial correlation on the Mann-Kendall test. Water Resources Research, 38(6), 4-1-4–7. <doi:10.1029/2001WR000861>

Salas, J.D., (1980). Applied modeling of hydrologic times series. Water Resources Publication.
}
