% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfpwmk.R
\name{tfpwmk}
\alias{tfpwmk}
\title{Mann-Kendall Test applied to Trend Free Pre-Whitened Time Series Data in Presence of Serial Correlation Using Yue and Pion (2002) Approach.}
\usage{
tfpwmk(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z-Value  - Z-Statistic after variance Correction

Sen's Slope  - Sen's slope for TFPW series

old. Sen's Slope  - Sen's slope for Original data series 'x'

P-value  - P-Value after variance correction

S  - Mann-Kendall 'S'- statistic

Var(s) - Variance of 's'

Tau  - Mann-Kendall's Tau
}
\description{
When the time series data is not random and influenced by auto-correlation, Pre-Whitening the time series prior to application of trend test is suggested.
}
\details{
Trend component is removed from the original data and sujected to Pre-Whitening by calculating lag-1 serial correlation coefficient. The data thus generated is tested with Mann-Kendall trend test.
}
\examples{
x<-c(Nile)
tfpwmk(x)

}
\references{
Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245–259. <doi:10.1017/CBO9781107415324.004>

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

Sen, P. K. (1968). Estimates of the Regression Coefficient Based on Kendall’s Tau. Journal of the American Statistical Association, 63(324), 1379. <doi:10.2307/2285891>

Yue, S., Pilon, P., Phinney, B., & Cavadias, G. (2002). The influence of autocorrelation on the ability to detect trend in hydrological series. Hydrological Processes, 16(9), 1807–1829. <doi:10.1002/hyp.1095>.

Salas, J.D., (1980). Applied modeling of hydrologic times series. Water Resources Publication.
}
