% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmkh.R
\name{mmkh}
\alias{mmkh}
\title{Modified Mann-Kendall Test For Serially Correlated Data Using Hamed and Rao (1998) Variance Correction Approach.}
\usage{
mmkh(x,ci=0.95)
}
\arguments{
\item{x}{- Time series data vector}

\item{ci}{- Confidence Interval}
}
\value{
Corrected Zc  - Z-Statistic after variance Correction

new P.value  - P-Value after variance correction

N/N*  - Effective sample size

Original Z  - Original Mann-Kendall Z-Statistic

Old P-value  - Original Mann-Kendall P-Value

Tau  - Mann-Kendall's Tau

Sen's Slope  - Sen's slope

old.variance - Old variance before variance Correction

new.variance - Variance after correction
}
\description{
Time series data is often influenced by sub-sequent observations. When data is not random and influenced by auto-correlation, Modified Mann-Kendall tests are to be used in trend detction studies. Hamed and Rao (1998) have proposed variance correction approach to address the issue of serial correlation in Trend analysis. Trend is removed from the series and effective sample size is calulated using significant serial correlation coefficients.
}
\details{
Trend free time series is constructed by calculating Sen's slope and Auto Correlation coefficient AR(1). Variance correction approach proposed by Hamed and Rao (1998) uses only significant values from all the available values of Auto-Correlation Coefficients.
}
\examples{
x<-c(Nile)
mmkh(x)

}
\references{
Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245–259. <doi:10.1017/CBO9781107415324.004>.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

sen, P. K. (1968). Estimates of the Regression Coefficient Based on Kendall’s Tau. Journal of the American statistical Association, 63(324), 1379. <doi:10.2307/2285891>.

Hamed, K. H., & Ramachandra Rao, A. (1998). A modified Mann-Kendall trend test for autocorrelated data. Journal of Hydrology, 204(1–4), 182–196. <doi:10.1016/S0022-1694(97)00125-X>.

Rao, A. R., Hamed, K. H., & Chen, H.-L. (2003). Nonstationarities in hydrologic and environmental time series. <doi:10.1007/978-94-010-0117-5>.

Salas, J.D., 1980. Applied modeling of hydrologic times series. Water Resources Publication.
}
