% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_mplus.R
\name{modsem_mplus}
\alias{modsem_mplus}
\title{Estimation latent interactions through mplus}
\usage{
modsem_mplus(
  model.syntax,
  data,
  estimator = "ml",
  type = "random",
  algorithm = "integration",
  process = "8",
  ...
)
}
\arguments{
\item{model.syntax}{lavaan/modsem syntax}

\item{data}{dataset}

\item{estimator}{estimator argument passed to mplus}

\item{type}{type argument passed to mplus}

\item{algorithm}{algorithm argument passed to mplus}

\item{process}{process argument passed to mplus}

\item{...}{arguments passed to other functions}
}
\value{
modsem_mplus object
}
\description{
Estimation latent interactions through mplus
}
\examples{
# Theory Of Planned Behavior
tpb <- '
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  ATT ~~ SN + PBC
  PBC ~~ SN
  # Causal Relationsships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC
  BEH ~ INT:PBC
'

\dontrun{
estTpbMplus <- modsem_mplus(tpb, data = TPB)
summary(estTpbLMS)
}

}
