% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose.R
\name{expose}
\alias{expose}
\title{Expose module contents}
\usage{
expose(module, ..., reInit = TRUE, where = parent.frame())
}
\arguments{
\item{module}{(character | module) a module as file or folder name or a list
representing a module.}

\item{...}{(character, or unquoted expression) elements to be exposed.
Defaults to all.}

\item{reInit}{(logical) whether to re-initialize module. This is only
relevant if a module has \emph{state} which can be changed. This argument
is passed to \link{as.module}.}

\item{where}{(environment) typically the calling environment. Should only be
relevant for testing.}
}
\description{
Use \code{expose} to copy the exported member of a module to the calling
environment. This is useful for a simple reexport of member functions and
generally for object composition.
}
\details{
You call this function for its side effects. It is a variation of
  \link{use} where instead of returning a module as return value, the
  elements are copied to the calling environment.
}
\examples{
m1 <- module({
  foo <- function() "foo"
})
m2 <- module({
  bar <- function() "bar"
})
# Now we create a module with 'foo' and 'bar' as member functions.
m3 <- module({
  expose(m1)
  expose(m2)
})
m3$foo()
m3$bar()
}
