% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{module}
\alias{autoTopEncl}
\alias{export}
\alias{expose}
\alias{import}
\alias{module}
\alias{print.module}
\alias{use}
\title{Define Modules in R}
\usage{
module(expr = { }, topEncl = autoTopEncl(parent.frame()))

\method{print}{module}(x, ...)

import(from, ..., where = parent.frame())

use(module, ..., attach = FALSE, reInit = TRUE, where = parent.frame())

expose(module, ..., reInit = TRUE, where = parent.frame())

export(..., where = parent.frame())

autoTopEncl(where)
}
\arguments{
\item{expr}{an expression}

\item{topEncl}{(environment) the root of the local search path. It is tried
to find a good default via \link{autoTopEncl}.}

\item{x}{a module}

\item{...}{(character, or unquoted expression) names to import from package
or names to export from module. For exports a character of length 1 with a
leading "^" is interpreted as regular expression.}

\item{from}{(character, or unquoted expression) a package name}

\item{where}{(environment) important for testing}

\item{module}{(character | module) a module as file or folder name or a list
representing a module.}

\item{attach}{(logical) whether to attach the module to the search path}

\item{reInit}{(logical) whether to re-initialize module. This argument is
passed to \link{as.module}.}
}
\description{
Use \code{module} to define self contained organizational units. Modules have
their own search path. \code{import} can be used to import packages.
\code{use} can be used to import other modules.
}
\details{
\code{topEncl} is the environment where the search of the module ends.
\code{autoTopEncl} handles the different situations. In general it defaults
to the base environment or the environment from which \code{module} has been
called. If you are using \code{use} or \code{expose} refering to a module in
a file, it will always be the base environment. When
\code{identical(topenv(parent.frame()), globalenv())} is false it (most
likely) means that the module is part of a package. In that case the module
defines a sub unit within a package but has access to the packages namespace.
This is relevant when you use the function module explicitly. When you define
a nested module which the module will connect to the calling environment.

\code{import} and \code{use} are no replacements for \link{library} and
\link{attach}. Both will work when called in the \code{.GlobalEnv} but should
only be used for development and debugging of modules.

\code{export} will never export a function with a leading "." in its name.

\code{expose} is similar to \code{use} but instead of attaching a module it
will copy all elements into the calling environment. This means that all
functions will be re-exported; if not stated otherwise using \code{export}.
}
\examples{
\dontrun{
vignette("modulesInR", "modules")
}

}

